/*
 * Decompiled with CFR 0.152.
 */
package projectvibrantjourneys.common.world.features.trunkplacers;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.TreeFeature;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.trunkplacer.AbstractTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.TrunkPlacerType;
import projectvibrantjourneys.init.world.PVJBlockPlacers;

public class TwistedTrunkPlacer
extends AbstractTrunkPlacer {
    public static final Codec<TwistedTrunkPlacer> CODEC = RecordCodecBuilder.create(x -> TwistedTrunkPlacer.func_236915_a_((RecordCodecBuilder.Instance)x).apply((Applicative)x, TwistedTrunkPlacer::new));

    public TwistedTrunkPlacer(int baseHeight, int heightA, int heightB) {
        super(baseHeight, heightA, heightB);
    }

    protected TrunkPlacerType<?> func_230381_a_() {
        return PVJBlockPlacers.ASPEN_TRUNK_PLACER;
    }

    public List<FoliagePlacer.Foliage> func_230382_a_(IWorldGenerationReader world, Random rand, int height, BlockPos pos, Set<BlockPos> blocks, MutableBoundingBox box, BaseTreeFeatureConfig config) {
        TwistedTrunkPlacer.func_236909_a_((IWorldGenerationReader)world, (BlockPos)pos.func_177977_b());
        ArrayList list = Lists.newArrayList();
        BlockPos blockpos = new BlockPos((Vector3i)pos);
        ArrayList<Direction> facings = new ArrayList<Direction>();
        int branchStart = 5 + rand.nextInt(4);
        for (int i = 0; i < height; ++i) {
            TwistedTrunkPlacer.func_236911_a_((IWorldGenerationReader)world, (Random)rand, (BlockPos)blockpos, blocks, (MutableBoundingBox)box, (BaseTreeFeatureConfig)config);
            blockpos = blockpos.func_177984_a();
            if (i <= branchStart || i % 2 != 0) continue;
            list.add(new FoliagePlacer.Foliage(blockpos, 0, false));
            int branchCount = rand.nextInt(3) + 1;
            for (int b = 0; b < branchCount; ++b) {
                int length = 2 + rand.nextInt(6);
                if (height >= 10) {
                    length -= (int)(0.3 * (double)height - 1.0);
                }
                Direction dir = Direction.Plane.HORIZONTAL.func_179518_a(rand);
                while (facings.contains(dir)) {
                    dir = Direction.Plane.HORIZONTAL.func_179518_a(rand);
                }
                facings.add(dir);
                BlockPos branchPos = new BlockPos((Vector3i)blockpos);
                for (int e = 1; e <= length; ++e) {
                    Direction temp;
                    BlockPos tempPos;
                    if (e > 1) {
                        if (rand.nextBoolean()) {
                            branchPos = branchPos.func_177971_a(dir.func_176730_m());
                        }
                        if (rand.nextBoolean()) {
                            branchPos = branchPos.func_177984_a();
                        }
                    }
                    if (!TreeFeature.func_236404_a_((IWorldGenerationBaseReader)world, (BlockPos)branchPos)) continue;
                    TwistedTrunkPlacer.func_236911_a_((IWorldGenerationReader)world, (Random)rand, (BlockPos)branchPos, blocks, (MutableBoundingBox)box, (BaseTreeFeatureConfig)config);
                    list.add(new FoliagePlacer.Foliage(branchPos, 0, false));
                    if (rand.nextInt(3) != 0 || !TreeFeature.func_236404_a_((IWorldGenerationBaseReader)world, (BlockPos)(tempPos = branchPos.func_177971_a((temp = Direction.Plane.HORIZONTAL.func_179518_a(rand)).func_176730_m())))) continue;
                    TwistedTrunkPlacer.func_236911_a_((IWorldGenerationReader)world, (Random)rand, (BlockPos)tempPos, blocks, (MutableBoundingBox)box, (BaseTreeFeatureConfig)config);
                    list.add(new FoliagePlacer.Foliage(tempPos, 0, false));
                }
                facings.clear();
            }
        }
        return list;
    }
}

